*Title: activeCollab System Requirements
*Slug: system-requirements

================================================================

activeCollab is a PHP-based application that must be installed on a server in order to run. If you have opted for the <{term}>self-hosted<{/term}> version of activeCollab, you can install the application on your own server.

The minimum system requirements that your web server must meet in order to run activeCollab are:

- A web server with **PHP 5.3 or PHP 5.4 support** (latest stable recommended) with <a href="http://www.php.net/manual/en/book.mysql.php">mysql</a>, <a href="http://www.php.net/manual/en/book.pcre.php">PCRE</a>, <a href="http://www.php.net/manual/en/book.xml.php">XML</a>, <a href="http://www.php.net/manual/en/book.ctype.php">ctype</a>, <a href="http://www.php.net/manual/en/book.tokenizer.php">tokenizer</a>, <a href="http://www.php.net/manual/en/book.session.php">session</a>, <a href="http://www.php.net/manual/en/book.dom.php">dom</a>, <a href="http://us3.php.net/book.phar.php">phar</a>, <a href="http://us3.php.net/book.zlib.php">zlib</a> and <a href="http://www.php.net/manual/en/book.json.php">json</a> extension installed. activeCollab is known to work well on Apache and IIS. Other web servers might also work, but we have not tested those configurations as thoroughly.
- A **MySQL database**.
- activeCollab comes with **no specific hardware requirements**. You should use hardware that can serve the platform that you have chosen (Windows, Linux, Mac OS etc) while running an application that uses between 50MB and 1GB of RAM (depending on the number of users, memory caching settings, etc).

<{note title="Recomended Server Configuration"}>The server configuration that we recommend and that has proven to give best results with activeCollab is:

- Apache 2 with support to run PHP scripts.
- PHP 5.4 with mysql, PCRE, XML, ctype, tokenizer, session, xml, dom, json, gd, mbstring, iconv, phar, zlib and IMAP extensions.
- MySQL 5 with InnoDB storage engine enabled.
- Memory limit set to at least 64MB, but we highly recommend 128MB (it is configured in your php.ini file). Depending on your reporting needs and the way that you configure thumbnail generation, more memory may be required in order to handle usage peaks (when preparing big reports or resizing big images).
- activeCollab does not work under eAccelerator or XCache. Disable them before installing activeCollab and consider using APC instead.
- For reliable production use, we recommend hosting with guaranteed resources (VPS or dedicated) over shared hosting.<{/note}>

There are a few PHO Extensions that can be used if you wish to use some of the additional activeCollab modules, but they are not essential for the system to operate. Here is a list of the additional extensions that you can use:

- To be able to use to use CAPTCHA protection with the <{page name="public-task-forms" book="tasks"}>Public Task Forms<{/page}>, you will need to have the <a href="http://us1.php.net/manual/en/book.image.php">GD extension</a> enabled with FreeType support.
- If you wish to use the <{page name="incoming-mail-setup"}>Incoming Mail<{/page}> module and enable activeCollab to receive and process emails, your server must have the <a href="http://www.php.net/manual/en/book.imap.php">IMAP PHP extension</a> installed.
- <a href="http://php.net/manual/en/book.svn.php">SVN extension</a> is also recommended if you wish to browse your SVN repository by using activeCollab Source Module.

<{sub}>Supported Browsers<{/sub}>

To access and use activeCollab, your users will need to have a modern web browser with JavaScript enabled. We officially support the following browser applications:

- Internet Explorer 9 and higher. The system also works in Internet Explorer 8, but some of the features may be slower or not as smoothly as with the latest version of Microsoft's browser. Please, use the latest stable version of the Internet Explorer for optimal performance.
- Latest stable version of Google Chrome.
- Latest stable version of Mozilla Firefox.
- Latest stable version of Apple Safari.

<{image name="browsers.jpg"}>

activeCollab is optimized for 1280x800px or a higher screen resolution. The application is also tested and works well in modern mobile browsers, such as Mobile Safari on the iPhone and iPad.